function F = ssfunm7revision(x,gamma,phi,betaP,BE_Yss,nuP,nuI,sigmanP,sigmanI, ...
                   sigmacP,sigmacI,alpha,sigmahI,Hss,sigmahP, ...
                   epsilonI,epsilonP,betaI,sbarI,betaE,sbarE, ...
                   Ass,delta,nI,nE,n,rhoP,rhoI,varthetaI,varthetaE,xiI,xiE) 

% Function to compute F in fsolve for seven central steady-state variables

% In the process, we make the following notation:

% x(1): Output, Yss
% x(2): Consumption, patient HHs, CPss
% x(3): Consumption, impatient HHs, CIss
% x(4): Land, impatient HHs, HIss
% x(5): Land, Entrepeneurs, HEss
% x(6): Labor, patient HHs, NPss
% x(7): Labor, impatient HHs, NIss


cell1 = ((1-nI-nE)*x(2)+nI*x(3))/(n*x(1)) - gamma ...
        - ((1-betaP)/betaP)*(nE/n)*BE_Yss ;

cell2 = nuP*(1-x(6))^(-sigmanP)*(x(2)*((1-rhoP)/(1-betaP*rhoP))) ...
        - alpha*gamma*(n/(1-nI-nE))*x(1)/x(6) ;

cell3 = nuI*(1-x(7))^(-sigmanI)*(x(3)*((1-rhoI)/(1-betaI*rhoI))) ...
        - (1-alpha)*gamma*(n/nI)*x(1)/x(7) ;

cell4 = (x(4)^sigmahI)*((1-nI-nE)^(sigmahP))*((Hss-nI*x(4)-nE*x(5))^-sigmahP) ...   
         *((1-betaI*rhoI)/(1-betaP*rhoP))*(x(2)/x(3)) ...    
        -((1-rhoI)/(1-rhoP))*(1-betaP)*(1-betaI*(1-varthetaI)*(1-xiI))*(epsilonI/epsilonP)/((1-betaI*(1-varthetaI)*(1-xiI))*(1-betaI)-(betaP-betaI)*varthetaI*sbarI) ;

cell5 =  (nI/n)*x(3)/x(1) - (1-alpha)*gamma ...
        +(1-betaP)*sbarI*nI*(x(4)^(1-sigmahI))*epsilonI*(1-betaI*(1-varthetaI)*(1-xiI))*((1-rhoI)/(1-betaI*rhoI))*x(3) ...
        *((n*x(1))^(-1))*(((1-betaI*(1-varthetaI)*(1-xiI))*(1-betaI)-(betaP-betaI)*varthetaI*sbarI)^(-1))*(varthetaI/(1-(1-varthetaI)*(1-xiI)));  



cell6 = (nE/n)*x(5)/x(1) - (1-gamma)*phi*betaE*(1-betaE*(1-varthetaE)*(1-xiE))*((1-betaI*(1-varthetaI)*(1-xiI))*(1-betaI)-(betaP-betaI)*varthetaI*sbarI)*(x(4)^(sigmahI)) ...
        /( ((1-betaE*(1-varthetaE)*(1-xiE))*(1-betaE)-(betaP-betaE)*varthetaE*sbarE)*epsilonI*(1-betaI*(1-varthetaI)*(1-xiI))*((1-rhoI)/(1-betaI*rhoI))*(x(3)^sigmacI) ) ; 


cell7 =  n*x(1) ...
         - (Ass^(1/gamma))*(((1-nI-nE)*x(6))^(alpha))*((nI*x(7))^((1-alpha))) ...    
       *(betaE*(1-gamma)*(1-phi)*(1-betaE*(1-varthetaE)*(1-xiE)))^((1-phi)*(1-gamma)/gamma) ...
       *((1-betaE*(1-varthetaE)*(1-xiE))*(1-betaE*(1-delta))-(betaP-betaE)*varthetaE*sbarE)^-((1-phi)*(1-gamma)/gamma) ...
       *((nE/n)*x(5)/x(1))^(phi*(1-gamma)/gamma) ;

F = [cell1 ;
     cell2 ;
     cell3 ;
     cell4 ;    
     cell5 ;
     cell6 ;
     cell7 ] ;         


